/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.mixin.block;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.block.CustomProperties;
import com.github.mim1q.convenientdecor.init.ModItems;
import com.github.mim1q.convenientdecor.item.WateringCanItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FarmBlock.class}, priority=2275)
public abstract class FarmlandBlockMixin
extends Block {
    private FarmlandBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Unique
    private boolean isUnhydratable() {
        return !this.m_49966_().m_61147_().contains(CustomProperties.HYDRATED);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructor(CallbackInfo ci) {
        if (this.isUnhydratable()) {
            return;
        }
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CustomProperties.HYDRATED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(method={"appendProperties"}, at={@At(value="HEAD")})
    private void appendProperties(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        if (!ConvenientDecor.CONFIG.features.wateringCanPermanentFarmland) {
            return;
        }
        builder.m_61104_(new Property[]{CustomProperties.HYDRATED});
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (this.isUnhydratable()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)CustomProperties.HYDRATED)).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"getPlacementState"}, at={@At(value="RETURN")}, cancellable=true)
    private void getPlacementState(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> cir) {
        int waterLevel;
        ItemStack offhandStack;
        if (this.isUnhydratable()) {
            return;
        }
        BlockState state = (BlockState)cir.getReturnValue();
        if (!state.m_60713_((Block)this)) {
            return;
        }
        boolean hydrated = false;
        Player player = ctx.m_43723_();
        if (player != null && (offhandStack = player.m_21120_(InteractionHand.OFF_HAND)) != null && offhandStack.m_150930_((Item)ModItems.WATERING_CAN) && (waterLevel = WateringCanItem.getWaterLevel(offhandStack)) > 0) {
            WateringCanItem.setWaterLevel(offhandStack, waterLevel - 1);
            hydrated = true;
        }
        cir.setReturnValue((Object)((BlockState)((BlockState)state.m_61124_((Property)CustomProperties.HYDRATED, (Comparable)Boolean.valueOf(hydrated))).m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(hydrated ? 7 : 0))));
    }
}

